//
// Atmel AVR JTAGICE Bootloader
//

#device 16
cpu.clock = 7372800;

#include <sys\regs16>
use R19 as WREG;
var i,j,cmd, tmp: byte;

// BOOTSZ = Fuses both blown, Bootrst also!
  org $1C00
//
// Main in Boot Block!
//
  cpu.stack := $3ff;

  // Init UART for 115200
  UBRRH := 0; 
  UBRRL := 23;  // 19.2 @7.3728

  UCSRA := $40; // TXEMPTY + 2X
  UCSRB := $18; // En TX/RX
  UCSRC := $86; // 8 bit

  repeat
    read(uart, cmd);
    switch cmd
      // Return Programmer Type
      "p": write(uart, "S"); // ??
          break;
      // Auto inc support
      "a":
          write(uart, "Y"); // ??
          break;
      // Return Software Ident
      "S":
          write(uart, "AVRBOOT");
          break;
      // Return supported devices
      "t":
          write(uart, $64, 0);
          break;
      // Return software version
      "V":
          write(uart, "21");
          break;
      // Select device
      "T": goto eat
      // Set addr
      "A":
          read(uart, R31, R30); // AH AL
          Z := Z + Z;           // convert word addr to byte
          write(uart, 13);
          break;
      // Enter Programming Mode
      "P":
          write(uart, 13);
          break;
      // Leave Programming Mode
      "L":
          write(uart, 13);
          break;
      // Read Signature
      // Return ATmega163 always!
      "s":
          write(uart, $1E,$94,$02);
          break;
      // Read Data
      "d" :
          EEARL := R30;
          EEARH := R31;
          eeprom.read;
          R0 := EEPROM.Data
          inc W30
          write(uart, R0);
          break;
      // Read Program memory
      "R" :
          R1 := ROM[W30]; inc Z
          R0 := ROM[W30]; inc Z
          write(uart, R0, R1);
          break;
      // Write Code low
      // also Write Page is buffer full!
      //
      "c" :
          read(uart,R15);

          // Erase Page !
          R16 := Z.Lo
          and R16,127
          if R16 = 0 then
            SPMCR := $03;   // Erase;
            const SPM1 ROM = $E8, $95

  	    Enable_RWW;

            R0 := $FF;
            R1 := $FF;
            push Z
            for R17 := 0 to 63
              SPMCR := $01; // Load
              const SPM5 ROM = $E8, $95
              Z := Z + 2;       // Increment byte address by 2
            next
            pop Z

	    // ?
            wait !SPMCR.0
//            wait (milli,30);
          end

          R0 := R15;

          write(uart,13);
          break;
      // Write Code high
      "C" :
          read(uart,R1);
          // Load to buffer

          SPMCR := $01; // Load
          const SPM2 ROM = $E8, $95

          Z := Z + 2;       // Increment byte address by 2
          write(uart,13);
          break;
      // Write Page
      "m" :
          SPMCR := $05; // Page Write
          const SPM3 ROM = $E8, $95
          // ??

          Enable_RWW;

          write(uart,13); // Done..
          break;
      // Fake Erase
      "e":

          write(uart, 13);
          break;
      // Erase!
      "U" :
          Z := 0;
          For R16 := 0 to 112
            SPMCR := $03;   // Erase;
            const SPM7 ROM = $E8, $95

  	    Enable_RWW;

//            Wait(milli, 16);
            Z := Z+128;     // Next Page
          next
          write(uart,13);
          break;

      // ---------- FAKE -----------
      // set LED
      "x": goto eat
      // clr LED
      "y":
eat:
         read(uart,wreg);
         write(uart,13);
         break;
      // ESCAPE
      $1B:
         break;
      default:
         write(uart,"?");
         break;
    end
  until false;

procedure Enable_RWW;
begin
  Wait !SPMCR.0;
  //
  SPMCR := $11;
end;

// We must include at end, to get Boot Block start OK

#include uart_boot16
#include <sys\wait1ms>